////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBPDFViewModel.h
//    Model component in MVC for PDF generation support.
//
//  Copyright (C) 2010 MYOB US, Inc., all rights reserved.
//
//  Change History (most recent first):
//
//	09/16/10  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#import <Cocoa/Cocoa.h>

@interface OBPDFViewElement : NSObject
{
	NSRect frame;
	NSRect clipRect;
	BOOL dashedLine;
}

-(instancetype)initWithFrame:(NSRect)frame NS_DESIGNATED_INITIALIZER;

@property (nonatomic) NSRect frame;

@property (nonatomic) NSRect clipRect;

@property (nonatomic) BOOL dashedLine;

@end


@interface PDFRectangleViewElement : OBPDFViewElement
{
	NSColor* frameColor;
	NSColor* fillColor;
	float lineWidth;
	float radius;
}

+(instancetype)PDFRectangleViewElementWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor
							lineWidth:(float)aLineWidth radius:(float)radius dashedLine:(BOOL)dashedLine;
+(instancetype)PDFRectangleViewElementWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor lineWidth:(float)aLineWidth
						   dashedLine:(BOOL)dashedLine;
+(instancetype)PDFRectangleViewElementWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor;
+(instancetype)PDFRectangleViewElementWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor lineWidth:(float)aLineWidth dashedLine:(BOOL)dashedLine;
+(instancetype)PDFRectangleViewElementWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor;
+(instancetype)PDFRectangleViewElementWithFrame:(NSRect)aFrame fillColor:(NSColor*)aFillColor;

-(instancetype)initWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor lineWidth:(float)aLineWidth
	radius:(float)radius dashedLine:(BOOL)dashedLine NS_DESIGNATED_INITIALIZER;
-(instancetype)initWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor lineWidth:(float)aLineWidth dashedLine:(BOOL)dashedLine;
-(instancetype)initWithFrame:(NSRect)aframe frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor;
-(instancetype)initWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor lineWidth:(float)aLineWidth dashedLine:(BOOL)dashedLine;
-(instancetype)initWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor;
-(instancetype)initWithFrame:(NSRect)aFrame fillColor:(NSColor*)aFillColor;
-(instancetype)init;

@property (nonatomic, copy) NSColor *frameColor;

@property (nonatomic, copy) NSColor *fillColor;

@property (nonatomic) float lineWidth;

@property (nonatomic) float radius;

@property (nonatomic, getter=isFilled, readonly) BOOL filled;

@end

@interface PDFOvalViewElement : OBPDFViewElement
{
	NSColor* frameColor;
	NSColor* fillColor;
	float lineWidth;
}

+(instancetype)PDFOvalViewElementWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor lineWidth:(float)aLineWidth
					  dashedLine:(BOOL)dashedLine;

-(instancetype)initWithFrame:(NSRect)aFrame frameColor:(NSColor*)aFrameColor fillColor:(NSColor*)aFillColor lineWidth:(float)aLineWidth
		dashedLine:(BOOL)dashedLine NS_DESIGNATED_INITIALIZER;
-(instancetype)init;

@property (nonatomic, copy) NSColor *frameColor;

@property (nonatomic, copy) NSColor *fillColor;

@property (nonatomic) float lineWidth;
@end


@interface PDFTextViewElement : OBPDFViewElement
{
	NSString* text;
	NSDictionary* textAttributes;
}

+(instancetype)PDFTextViewElementWithFrame:(NSRect)frame text:(NSString*)text textAttributes:(NSDictionary*)textAttributes;

-(instancetype)initWithFrame:(NSRect)frame text:(NSString*)text textAttributes:(NSDictionary*)textAttributes NS_DESIGNATED_INITIALIZER;

@property (nonatomic, copy) NSString *text;

@property (nonatomic, copy) NSDictionary *textAttributes;

@end

@interface PDFPolygonViewElement : OBPDFViewElement
{
	NSData* points;
	NSColor* lineColor;
	NSColor* fillColor;
	float lineWidth;
}

+(instancetype)PDFPolygonViewElementWithPoints:(NSData*)pointsArray lineColor:(NSColor*)aLineColor fillColor:(NSColor*)aFillColor
						   lineWidth:(float)aLineWidth dashedLine:(BOOL)aDashedLine;

-(instancetype)initWithPoints:(NSData*)pointsArray lineColor:(NSColor*)aLineColor fillColor:(NSColor*)aFillColor lineWidth:(float)aLineWidth
		 dashedLine:(BOOL)aDashedLine NS_DESIGNATED_INITIALIZER;

@property (nonatomic, copy) NSData *points;

@property (nonatomic, readonly) NSPointArray pointArray;
@property (nonatomic, readonly) NSUInteger pointCount;

@property (nonatomic, copy) NSColor *lineColor;

@property (nonatomic, copy) NSColor *fillColor;

@property (nonatomic) float lineWidth;

@end

@interface PDFImageViewElement : OBPDFViewElement
{
	NSImage* image;
}

+(instancetype)PDFImageViewElement:(NSImage*)image inDestinationRect:(NSRect)rect;
+(instancetype)PDFImageViewElement:(NSImage*)image inDestinationRect:(NSRect)rect withClipRect:(NSRect)clipRect;

-(instancetype)initWithImage:(NSImage*)image inDestinationRect:(NSRect)rect NS_DESIGNATED_INITIALIZER;
-(instancetype)initWithImage:(NSImage*)imageIn inDestinationRect:(NSRect)rect withClipRect:(NSRect)clipRect NS_DESIGNATED_INITIALIZER;

@property (nonatomic, copy) NSImage *image;

@property (nonatomic) NSRect destinationRect;

@end

@interface OBPDFViewModel : NSObject
{
@private	
	NSMutableArray* pdfViewElements;
	NSMutableArray* lastViewElementOfEachPage;
	NSUInteger pageCount;
}

-(instancetype)init;

@property (nonatomic, readonly, copy) NSArray *pdfViewElements;

-(void)addPDFViewElement:(OBPDFViewElement*)viewElement;

@property (nonatomic) NSUInteger pageCount;
-(void)incrementPageCount;

-(long)firstViewElementforPage:(NSUInteger)page;
-(long)lastViewElementforPage:(NSUInteger)page;

@end
